#!/bin/sh

if [ "$1" == '-h' -o "$1" == '--help' ]; then
  echo 'Usage: asynRecord.sh [PV_PREFIX [ASYN_RECORD_DEVICE]]'
  echo 'Parameters:'
  echo '  PV_PREFIX           PV name prefix (default: "ioc23:")'
  echo '  ASYN_RECORD_DEVICE  Name of asyn record device (default: '
  echo '                      "asyn_pmacClipper")'
  echo 'Example: asynRecord.sh'
  echo 'Example: asynRecord.sh ioc1: asyn_pmacClipper2'
  exit 0
fi

pvPrefix=ioc23:
if [ "$1" != '' ]; then pvPrefix="$1"; fi
asynRecordDevice=asyn_pmacClipper
if [ "$2" != '' ]; then asynRecordDevice="$2"; fi

exec medm -x -macro "P=$pvPrefix,R=$asynRecordDevice" asynRecord.adl
