#!/bin/sh

if [ "$1" == '-h' -o "$1" == '--help' ]; then
  echo 'Usage: control.sh [P [E]]'
  echo 'Parameters:'
  echo '  P   PV prefix (default: "ioc23:")'
  echo '  E   Exphi name (default: "Exphi")'
  echo 'Example: control.sh'
  echo 'Example: control.sh ioc1: Exphi2'
  exit 0
fi

pvPrefix='ioc23:'
if [ "$1" != '' ]; then pvPrefix="$1"; fi
exphiName='Exphi'
if [ "$2" != '' ]; then exphiName="$2"; fi

thisScriptHome=`dirname "$0"`
cd "$thisScriptHome"
if [ $? -ne 0 ]; then
  echo "Failed to cd to \"$thisScriptHome\"." 1>&2
  exit 1
fi
thisScriptHome=`pwd`
if [ $? -ne 0 ]; then
  echo 'Failed to get current working directory.' 1>&2
  exit 1
fi

cd "../src"
if [ $? -ne 0 ]; then
  echo "Failed to cd to \"$thisScriptHome/../src\"." 1>&2
  exit 1
fi

exec medm -x -macro "P=$pvPrefix,E=$exphiName" ./exphi.adl
