#!/bin/sh

if [ "$1" == '-h' -o "$1" == '--help' ]; then
  echo 'Usage: motor.sh [P [M]]'
  echo 'Parameters:'
  echo '  P  PV prefix (default: "ioc23:")'
  echo '  M  Motor (default: "m1")'
  echo 'Example: motor.sh'
  echo 'Example: motor.sh ioc1: m2'
  exit 0
fi

pvPrefix='ioc23:'
if [ "$1" != '' ]; then pvPrefix="$1"; fi
motorName='m1'
if [ "$2" != '' ]; then motorName="$2"; fi

exec medm -x -macro "P=$pvPrefix,M=$motorName" motorx_more.adl
