# Create low-level simulated motor
# motorSimCreate(int card, int axis, int lowLimit, int hiLimit, int home,
#   int nCards, int nAxes, int startPosn)
motorSimCreate(0,  0, -10000000, 10000000, 0, 1, 1, 0)

# Create simulated asyn motor
# drvAsynMotorConfigure(const char *portName, const char *driverName,
#   int card, int num_axes)
# portName   = asyn port name
# driverName = name of low-level driver
# card       = card to use
# num_axes   = number of axes on card
drvAsynMotorConfigure("motorSim1", "motorSim", 0, 1)

# Load Phi motor simulation
dbLoadTemplate("src-sim/motor.template")

# Configure asyn TCP/IP port for ASCII communication with PMAC
drvAsynIPPortConfigure("pmacClipper","127.0.0.1:50436",0,0,0)
epicsThreadSleep(1.0) # avoid warning message about already being connected
asynOctetSetInputEos("pmacClipper",0,"\006")
asynOctetSetOutputEos("pmacClipper",0,"\r")

# Asyn record device for asyn TCP/IP port
dbLoadRecords("$(ASYN)/db/asynRecord.db","P=ioc23:,R=asyn_pmacClipper,PORT=pmacClipper,ADDR=0,OMAX=256,IMAX=256")

# Load exphi database
dbLoadRecords("src/exphi.db","P=ioc23:,E=Exphi,PORT=pmacClipper,TMOT=1.0,AV=P1,OPV=P2,CPV=P3,EPEV=P4,EPV=P5,MTV=P6,SV=P7,EV=P8,SP=8,OP=3,PP=3,DESC='17-ID-B'")
